clear all

load('ruiuj.mat');
y0=0;
dz0=0;
dy0=0;
dt0=0;
[dz,dy,y,dt]=ndgrid(dz0,dy0,y0,dt0);
u12=corrn(ruiuj,1,1,y,dy,dz,dt);
u22=corrn(ruiuj,2,2,y,dy,dz,dt);
u32=corrn(ruiuj,3,3,y,dy,dz,dt);

figure(2);set(gcf,'Position',[407   705   421   204]);
y0=0;
dz0=-3.5:0.1:3.5;
dy0=0;
dt0=0;
[dz,dy,y,dt]=ndgrid(dz0,dy0,y0,dt0);
r13=corrn(ruiuj,1,1,y,dy,dz,dt)/u12;
% r13(find(isnan(r13)))=0.0;
r23=corrn(ruiuj,2,2,y,dy,dz,dt)/u22;
% r23(find(isnan(r23)))=0.0;
r33=corrn(ruiuj,3,3,y,dy,dz,dt)/u32;
% r33(find(isnan(r33)))=0.0;
plot(dz0,r13,'k-');hold on;
plot(dz0,r23,'k:');
plot(dz0,r33,'k--');
legend('\rho_1_1','\rho_2_2','\rho_3_3');
xlabel('\Deltax_2/L_w');
ylim([-.2 1.001]);xlim([-3.5 3.5]);
hold off

figure(3);set(gcf,'Position',[305   423   599   204]);
y0=0;
dz0=0;
dy0=0;
dt0=-5:0.1:5;
[dz,dy,y,dt]=ndgrid(dz0,dy0,y0,dt0);
r13=squeeze(corrn(ruiuj,1,1,y,dy,dz,dt)/u12);
% r13(find(isnan(r13)))=0.0;
r23=squeeze(corrn(ruiuj,2,2,y,dy,dz,dt)/u22);
% r23(find(isnan(r23)))=0.0;
r33=squeeze(corrn(ruiuj,3,3,y,dy,dz,dt)/u32);
% r33(find(isnan(r33)))=0.0;
plot(dt0,r13,'k-');hold on;
plot(dt0,r23,'k:');
plot(dt0,r33,'k--');
legend('\rho_1_1','\rho_2_2','\rho_3_3');
xlabel('\tauU_\infty/L_w');
ylim([-.2 1.001]);xlim([-5 5]);
hold off

   