
function a=corrn(ruiuj,i,j,y,dy,dz,dt)
% INTERPOLATES THE TWO POINT CORRELATION TENSOR AT POINTS SPECIFIED IN TERMS OF NORMALIZED VARIABLES
% ruiuj[3 3 17 41 21 65], Correlation tensor; indices represent respectively
%			index of velocity component at y,0
%			index of velocity component at y+dy,dz
%			integer vertical position delta, delta=1 for zero y
%			transformed integer vertical separation beta, beta=21 for zero dy
%			transformed integer spanwise separation gamma, gamma=1 for zero dz
%			transformed integer time delay alpha, alpha=33 for zero time delay
% i, scalar index of velocity component at y,0
% j, scalar index of velocity component a y+dy,dz
% y, array of normal positions (in wake half thicknesses Lw) for which correlations are desired
%			-2.740<y/Lw<2.740 Out of range values return NaN.
% dy, array of normal separations (in wake half thicknesses Lw) at which correlations are desired
%			-3.497<dy/Lw<3.497. Out of range values return NaN.
% dz, array of spanwise separations (in wake half thicknesses Lw) at which correlations are desired 
%			-3.497<dz/Lw<3.497. Out of range values return NaN.
% dt, array of time delays (in Lw/Uinf) at which correlations are desired 
%			-8.048<dtUinf/Lw<8.048. Out of range values return NaN.
% NOTES
% (1) Interpolations for positive dz and y values are obtained from corresponding
% negative dz and y values by assuming symmetry in the correlation function.
% (2) dt,dz,dy,y must be monotonic and plaid (as if created by NDGRID)

%arrays holding reverse signs of dz and y
ysign=-sign(y)+not(y); 		%not function ensures ysign=1 if y=0
%dzsign=-sign(dz);          %if dz = 0 then all w cross correlations must be zero, so dzsign is left as zero, see last if clause
dzsign=sign(dz);          %Sign correction made 6/27/01, see Devenport5-11-01.xls

%time delay index
alpha=sign(dt).*sqrt(abs(dt./8.048)).*32+33;
%dy index, reverse sign of index if y is positive
beta=sign(dy.*ysign).*sqrt(abs(dy./3.497)).*20+21;
%dz index, ignores sign of dz
gamma=sqrt(abs(dz./3.497)).*20+1;
%y index, ignores sign of y
delta=abs(y)./0.1712+1;

a=interpn(squeeze(ruiuj(i,j,:,:,:,:)),delta,beta,gamma,alpha,'*cubic');

%if i eor j is 2 (i.e. uv, vw, vu, wv) and y was positive reverse sign of correlation
if (i==2 | j==2) & ~(j==2 & i==2)
   a=a.*ysign;
end

%if i eor j is 3 (i.e. uw, vw, wv, wu) and dz was positive reverse sign of correlation
if (i==3 | j==3) & ~(i==3 & j==3)
   a=a.*dzsign;
end
