clear all

load('ruiuj.mat');
y0=0;
dz0=0;
dy0=0;
dt0=0;
[dz,dy,y,dt]=ndgrid(dz0,dy0,y0,dt0);
u11=corrn(ruiuj,1,1,y,dy,dz,dt);
u22=corrn(ruiuj,2,2,y,dy,dz,dt);
u33=corrn(ruiuj,3,3,y,dy,dz,dt);

figure(4)
zstep=0.1;
y0=-2.4:.15:2.4;
dz0=-3.4:zstep:3.4;
dy0=0;
dt0=0;
[dz,dy,y,dt]=ndgrid(dz0,dy0,y0,dt0);
L13=sum(squeeze(corrn(ruiuj,1,1,y,dy,dz,dt)))*zstep/u11/2;
L23=sum(squeeze(corrn(ruiuj,2,2,y,dy,dz,dt)))*zstep/u22/2;
L33=sum(squeeze(corrn(ruiuj,3,3,y,dy,dz,dt)))*zstep/u33/2;
plot(y0,L13,'k-');hold on;
plot(y0,L23,'k:');
plot(y0,L33,'k--');
legend('L_1_3/L_w','L_2_3/L_w','L_3_3/L_w');
xlabel('x_2/L_w');
xlim([-3 3]);
hold off
set(gcf,'Position',[257   539   396   248]);

figure(5)
tstep=0.1;
y0=-2.4:.15:2.4;
dz0=0;
dy0=0;
dt0=-8:tstep:8;
[dz,dy,y,dt]=ndgrid(dz0,dy0,y0,dt0);
L11=sum(squeeze(corrn(ruiuj,1,1,y,dy,dz,dt)),2)*tstep/u11/2;
L21=sum(squeeze(corrn(ruiuj,2,2,y,dy,dz,dt)),2)*tstep/u22/2;
L31=sum(squeeze(corrn(ruiuj,3,3,y,dy,dz,dt)),2)*tstep/u33/2;
plot(y0,L11,'k-');hold on;
plot(y0,L21,'k:');
plot(y0,L31,'k--');
legend('L_1_1/L_w','L_2_1/L_w','L_3_1/L_w');
xlabel('x_2/L_w');
xlim([-3 3]);
hold off
set(gcf,'Position',[257   262   396   248]);

   