clf;clear all
% Data for 8.34 chordlengths aft of the trailing edge
Y=[-3.03E+00	-2.88E+00	-2.73E+00	-2.59E+00	-2.44E+00	-2.30E+00	-2.15E+00	-2.01E+00	-1.86E+00	-1.71E+00	-1.57E+00	-1.42E+00	-1.28E+00	-1.13E+00	-9.86E-01	-8.40E-01	-6.94E-01	-5.49E-01	-4.03E-01	-2.57E-01	-1.11E-01	3.44E-02	1.80E-01	3.26E-01	4.72E-01	6.17E-01	7.63E-01	9.09E-01	1.05E+00	1.20E+00	1.35E+00	1.49E+00	1.64E+00	1.78E+00	1.93E+00	2.07E+00	2.22E+00	2.37E+00	2.51E+00	2.66E+00	2.80E+00	2.95E+00	3.09E+00];
U=[1.44E-02	2.52E-02	5.40E-03	-1.80E-02	5.40E-03	5.40E-03	5.40E-03	2.34E-02	5.04E-02	9.89E-02	1.76E-01	2.64E-01	3.33E-01	4.01E-01	5.11E-01	6.33E-01	7.01E-01	8.02E-01	9.21E-01	9.82E-01	9.86E-01	1.00E+00	9.91E-01	9.37E-01	8.63E-01	7.90E-01	6.80E-01	5.76E-01	4.55E-01	3.87E-01	2.73E-01	2.18E-01	1.37E-01	1.15E-01	6.48E-02	2.16E-02	1.44E-02	1.26E-02	-3.60E-02	-1.80E-02	3.60E-03	3.60E-03	-1.80E-02];
u2=[2.52E-03	2.37E-03	3.05E-03	3.88E-03	4.77E-03	7.00E-03	9.85E-03	1.61E-02	2.34E-02	3.69E-02	5.14E-02	7.17E-02	8.74E-02	1.01E-01	1.11E-01	1.16E-01	1.21E-01	1.17E-01	1.13E-01	1.02E-01	9.96E-02	9.81E-02	1.00E-01	1.06E-01	1.14E-01	1.18E-01	1.22E-01	1.18E-01	1.09E-01	9.72E-02	8.23E-02	6.66E-02	4.94E-02	3.30E-02	2.22E-02	1.41E-02	9.03E-03	6.04E-03	4.53E-03	3.56E-03	3.00E-03	2.79E-03	2.58E-03];
v2=[1.45E-03	1.79E-03	2.68E-03	3.76E-03	5.74E-03	8.83E-03	1.37E-02	2.13E-02	2.90E-02	3.90E-02	5.22E-02	6.66E-02	7.69E-02	8.97E-02	9.81E-02	1.07E-01	1.12E-01	1.14E-01	1.15E-01	1.16E-01	1.16E-01	1.16E-01	1.16E-01	1.18E-01	1.17E-01	1.13E-01	1.12E-01	1.04E-01	9.62E-02	8.61E-02	7.36E-02	6.11E-02	4.90E-02	3.64E-02	2.71E-02	1.89E-02	1.26E-02	8.52E-03	5.63E-03	3.47E-03	2.51E-03	1.81E-03	1.49E-03];
w2=[7.17E-04	8.42E-04	1.11E-03	1.62E-03	2.66E-03	4.48E-03	7.04E-03	1.16E-02	1.80E-02	2.65E-02	3.83E-02	4.96E-02	6.42E-02	7.73E-02	8.65E-02	9.31E-02	9.70E-02	9.54E-02	9.39E-02	8.76E-02	8.53E-02	8.47E-02	8.66E-02	9.07E-02	9.58E-02	9.73E-02	9.68E-02	9.17E-02	8.32E-02	7.22E-02	5.98E-02	4.66E-02	3.49E-02	2.46E-02	1.61E-02	1.07E-02	6.19E-03	3.69E-03	2.28E-03	1.51E-03	1.08E-03	8.87E-04	7.63E-04];
uv=[8.83E-05	9.32E-05	5.81E-05	2.10E-04	5.96E-04	1.45E-03	2.49E-03	5.57E-03	8.43E-03	1.38E-02	1.97E-02	2.67E-02	3.23E-02	3.82E-02	4.16E-02	4.29E-02	4.22E-02	3.79E-02	3.10E-02	2.01E-02	1.05E-02	-1.26E-03	-1.42E-02	-2.57E-02	-3.54E-02	-3.99E-02	-4.50E-02	-4.38E-02	-4.16E-02	-3.66E-02	-3.16E-02	-2.55E-02	-1.93E-02	-1.27E-02	-8.36E-03	-4.56E-03	-2.32E-03	-1.15E-03	-4.42E-04	-2.77E-05	2.70E-05	5.06E-05	1.31E-04];

markers={'o','s','^','d','v'};
legs={'(U_1-U_\infty)/U_w','u_1^2/U_\infty^2','u_2^2/U_\infty^2','u_3^2/U_\infty^2','u_1u_2/U_\infty^2'};
figure(1)

subplot(3,1,1)
hh(1)=plot(Y,-U,['k' markers{1}]);hold on;
plot(Y,-exp(-0.637*Y.^2-.056*Y.^4),'k-');hold off;
ylim([-1 0]);
xlim([-3 3]);
ylabel(legs{1});
set(gca,'XtickLabel','')

subplot(3,1,2);
hh(2)=plot(Y,u2,['k' markers{2}]);
hold on
set(gca,'position',[.18 .68 .73, .25]);
hh(3)=plot(Y,v2,['k' markers{3}]);
hh(4)=plot(Y,w2,['k' markers{4}]);
hold off
set(gca,'position',[.18 .40 .73, .25]);
legend(legs{2:4});
ylim([0 0.15001]);
xlim([-3 3]);
set(gca,'XtickLabel','')

subplot(3,1,3);
hh(5)=plot(Y,uv,['k' markers{5}]);
set(gca,'position',[.18 .12 .73, .25]);
xlabel('x_2/L_w');
ylabel(legs{5});
xlim([-3 3]);

for n=1:5
    set(hh(n),'Markersize',5);
end

set(gcf,'Position',[90   300   395   522]);

