clear all

load('ruiuj.mat');
y0=0;
dz0=0;
dy0=-2.4:.15:2.4;
dt0=0;
[dz,dy,y,dt]=ndgrid(dz0,dy0,y0,dt0);
u2{1}=squeeze(corrn(ruiuj,1,1,y,dy,dz,dt));
u2{2}=squeeze(corrn(ruiuj,2,2,y,dy,dz,dt));
u2{3}=squeeze(corrn(ruiuj,3,3,y,dy,dz,dt));

figure(6);
set(gcf,'Position',[10   300   750   250]);
iind=[1 2 3];
jind=[1 2 3];

for n=1:3
    y0=-2.4:.15:2.4;
    y0p=-2.4:.15:2.4;
    dz0=0;
    dt0=0;
    [dz,yp,y,dt]=ndgrid(dz0,y0p,y0,dt0);
    dy=yp-y;
    R=squeeze(corrn(ruiuj,iind(n),jind(n),y,dy,dz,dt));
    u2=diag(R);
    rho=R./sqrt(u2*u2');
    
    subplot(1,3,n);
    [cc hh]=contour(y0,y0,rho,[.1:.1:1.3],'k-');hold on;
    [cc hh]=contour(y0,y0,rho,[-.5:.1:-.099],'k-');
    set(hh,'LineStyle',':');
    [cc hh]=contour(y0,y0,rho,[0 0],'k-');
    set(hh,'LineWidth',1.5);
    set(hh,'LineColor',[0.7 0.7 0.7]);
    xlim([-2.001 2.001]);ylim([-2.001 2.001]);
    xlabel('x_2/L_w');
    if n==1 
        ylabel('x_2/L_w');
    else
        set(gca,'YtickLabel','')
    end
    switch n
        case 1
            set(gca,'Position',[0.10    0.11    0.27    0.81]);
        case 2
            set(gca,'Position',[0.39    0.11    0.27    0.81]);
        case 3
            set(gca,'Position',[0.68    0.11    0.27    0.81]);
    end
    hold off
    %integral scales
    L=trapz(y0,rho(17,:))/2;
    disp(['L' num2str(n) '2 = ' num2str(L) 'Lw']);
end

   