clear all;
figure
thetac=[.5:179.5]*pi/180;
M=.3;h=.5;
xdata=[];ydata=[];
for M=[.05 .1:.1:.71]
    thetai=2*atan(1/(1-M)*(sqrt(csc(thetac).^2-M^2)-cot(thetac)));
    secthetat=1./cos(thetai)+M;
    costhetat=1./secthetat;
    sinthetat=sqrt(1-costhetat.^2);
    thetam=acot(h*cot(thetac)+sign(secthetat).*(1-h)./sqrt(secthetat.^2-1));
    a=find(thetam<0);
    thetam(a)=thetam(a)+pi;
    a=find(abs(imag(thetam))>1e-10);
    b=find(abs(imag(thetam))<=1e-10);
    thetam(find(abs(imag(thetam))>1e-10))=nan;
    
    zeta=sqrt((1-M.*costhetat).^2-costhetat.^2);
    pcpm2=1/4./zeta.^2.*h.^2.*(1+(1./h-1).*zeta.^3./sinthetat.^3).*(1+(1./h-1).*zeta./sinthetat).*(zeta+sinthetat.*(1-M.*costhetat).^2).^2;
    pcpmdB=10*log10(pcpm2);
    plot(thetam(b)*180/pi,pcpmdB(b),'k-');
    xdata=[xdata M thetam(b)*180/pi];
    ydata=[ydata length(thetam(b)) pcpmdB(b)];
    hold on
end

hold off
xlabel('\theta_m');ylabel('p_c/p_m (dB)');title(['h/H = ' num2str(h)]);
ylim([-5 15])
xlim([0 180])
grid on;
set(gcf,'Position',[405   379   304   357]);
set(gca,'XTick',[0 45 90 135 180]);
