clear all; % close all
figure
thetac=[.5:179.5]*pi/180;
M=.2;Hh=[1.1 1.2 1.5 2 3 5 10 20];hH=1./Hh;
xdata=[];ydata=[];
for h=hH
    thetai=2*atan(1/(1-M)*(sqrt(csc(thetac).^2-M^2)-cot(thetac)));
    secthetat=1./cos(thetai)+M;
    thetam=acot(h*cot(thetac)+sign(secthetat).*(1-h)./sqrt(secthetat.^2-1));
    a=find(thetam<0);
    thetam(a)=thetam(a)+pi;
    thetam(find(abs(imag(thetam))>1e-10))=nan;
    plot(thetam*180/pi,(thetam-thetac)*180/pi,'k-');
    xdata=[xdata 1/h thetam*180/pi];
    ydata=[ydata length(thetam) (thetam-thetac)*180/pi];
    hold on
end

%Limiting case
thetam=thetac;
thetacL=atan(sqrt((1-M*cos(thetam)).^2-cos(thetam).^2)./((1-M^2)*cos(thetam)+M));
a=find(thetacL<0);
thetacL(a)=thetacL(a)+pi;
a=find(abs(imag(thetacL))<1e-10);
plot(thetam(a)*180/pi,(thetam(a)-thetacL(a))*180/pi,'k-.');


hold off
xlabel('\theta_m');ylabel('\theta_m - \theta_c');title(['M = ' num2str(M)]);
% clabel([xdata; ydata]);
ylim([0 45])
xlim([0 180])
grid on;
set(gcf,'Position',[405   379   304   357]);
set(gca,'XTick',[0 45 90 135 180]);

