clear all; %close all
figure
thetac=[.5:179.5]*pi/180;
M=.3;h=.5;
xdata=[];ydata=[];
for M=[.05:.05:.31 .4:.1:.71]
    thetai=2*atan(1/(1-M)*(sqrt(csc(thetac).^2-M^2)-cot(thetac)));
    secthetat=1./cos(thetai)+M;
    thetam=acot(h*cot(thetac)+sign(secthetat).*(1-h)./sqrt(secthetat.^2-1));
    a=find(thetam<0);
    thetam(a)=thetam(a)+pi;
    thetam(find(abs(imag(thetam))>1e-10))=nan;
    plot(thetam*180/pi,(thetam-thetac)*180/pi,'k-');
    xdata=[xdata M thetam*180/pi];
    ydata=[ydata length(thetam) (thetam-thetac)*180/pi];
    hold on
end

hold off
xlabel('\theta_m');ylabel('\theta_m - \theta_c');title(['h/H = ' num2str(h)]);
%clabel([xdata; ydata]);
ylim([0 45])
xlim([0 180])
grid on;
set(gcf,'Position',[405   379   304   357]);
set(gca,'XTick',[0 45 90 135 180]);
