function [f,SPL_TOT,SPL_S,SPL_P,SPL_A,deltaS_p,deltaS_s]=BPM_TBL_TE_Noise(parm)

r_e = parm.r_e; % Retarded source to observer distance, in m, scalar.
theta= parm.theta; % Retarded source to observer angle in degrees measured from downstream, scalar
phi = parm.phi; %Lateral directivity angle term in degrees, scalar
c = parm.c; %Chordlength(m). Scalar or 1xN vector 
L = parm.L; %Span (m). Scalar or 1xN vector
alpha=parm.alpha; %Angle of attack in degrees. Scalar or 1xN vector
U = parm.U; %Free stream velocity. Scalar or 1xN vector 
v = parm.v; %Kinetmatic Viscosity of air in m^2/s
c0 = parm.c0; %Speed of sound in m/s
trip = parm.trip; %Trip condition, 0 - untripped, 1 - tripped (BPM fit), 2 - prescribed delta*
deltaS_s=parm.deltaS_s; %Prescribed suction side delta*
deltaS_p=parm.deltaS_p; %Prescribed pressure side delta*
showplot=parm.plot; % 1 for plot or 0 for no plot

f=0:10:50000;

for j=1:1:length(alpha)
    M=U(j)/c0; %calculating mach number
    R_c = U(j)*c(j)/v; %Reynolds number based on chord
    if trip==1 %BPM trip
        if R_c<300000  %tripped BL at zero AOA
            deltaS_0=c(j)*0.0601*R_c^(-0.114);
        else
            deltaS_0=c(j)*10^(3.411-1.5397*log10(R_c)+0.1059*log10(R_c)^2);
        end
        %For pressure side of both tripped and untripped boundary layers based on NACA 0012
        deltaS_p = deltaS_0*10^(-.0432*alpha(j)+.00113*alpha(j)^2);
        %For suction side tripped boundary layers
        if alpha(j)<5
            deltaS_s=deltaS_0*10^(0.0679*alpha(j));
        elseif alpha(j)<12.5
            deltaS_s=deltaS_0*0.381*10^(0.1516*alpha(j));
        else
            deltaS_s=deltaS_0*14.296*10^(0.0258*alpha(j));
        end
    elseif trip==0 %untripped
        %For untripped boundary layers based on NACA 0012 
        delta_0 = c(j)*10^(1.6569-0.9045*log10(R_c)+.0596*(log10(R_c))^2);
        deltaS_0 = c(j)*10^(3.0187-1.5397*log10(R_c)+.1059*(log10(R_c))^2);
        %For pressure side of both tripped and untripped boundary layers based on NACA 0012
        delta_p = delta_0*10^(-.04175*alpha(j)+.00106*alpha(j)^2);
        deltaS_p = deltaS_0*10^(-.0432*alpha(j)+.00113*alpha(j)^2);
        %For suction side of untripped boundary layer based in NACA 0012
        if alpha(j) <= 7.5; 
            delta_s = delta_0*10^(.03114*alpha(j));
        else if alpha(j) > 12.5;
                delta_s = delta_0*12*(10^(.0258*alpha(j)));
            else
                delta_s = delta_0*.0303*(10^(.2336*alpha(j)));
            end
        end
        if alpha(j) <= 7.5; 
            deltaS_s = deltaS_0*10^(.0679*alpha(j));
        else if alpha(j) > 12.5;
                deltaS_s = deltaS_0*52.42*(10^(.0258*alpha(j)));
            else
                deltaS_s = deltaS_0*.0162*(10^(.3066*alpha(j)));
            end
        end
    end
    
    R_deltaS_p = (U(j)*deltaS_p)/v;

    St_p = f.*deltaS_p/U(j); %calculating Strouhal numbers
    St_s = f.*deltaS_s/U(j);
    St_1 = .02*(M^-.6);

    %determining Strouhal number from angle of attack
    if alpha(j) < 1.33;
        St_2 = St_1;
    else if alpha(j) > 12.5;
            St_2 = St_1*4.72;
        else
             St_2 = St_1*10^(.0054*(alpha(j)-1.33)^2);
        end
    end

    as = abs(log10(St_s/St_1)); %a for  suction side
    ap = abs(log10(St_p/St_1)); %a for pressure side
    anew = abs(log10(St_s/St_2));

    if R_c < 9.52*10^4;
        a_0 = .57;
    else if R_c > 8.57*10^5;
           a_0 = 1.13;
        else
             a_0 = (-9.57*10^-13)*((R_c-(8.57*10^5))^2)+1.13;
        end
    end

    A_R = (-20-A_min(a_0))/(A_max(a_0)-A_min(a_0));
    As = A_min(as)+A_R*(A_max(as)-A_min(as)); %calculating spectral shape function
    Ap = A_min(ap)+A_R*(A_max(ap)-A_min(ap));

    b = abs(log10(St_s/St_2));

    %determining b_0 based on Reynolds number
    if R_c < 9.52*10^4;
        b_0 = .3;
    else if R_c > 8.57*10^5;
            b_0 = .56;
        else 
            b_0 = (-4.48*10^-13)*((R_c-(8.57*10^5))^2)+.56;
        end
    end

    B_R = (-20-B_min(b_0))/(B_max(b_0)-B_min(b_0));
    B = B_min(b)+B_R*(B_max(b)-B_min(b)); %calculating spectral shape function

    theta = theta*(pi/180); %converting theta and phi from degrees to radians
    phi = phi*(pi/180);

    M_c = .6*U(j)/c0; %Convective Mach number

    D_h = (2*(sin(theta(j)/2)^2)*(sin(phi)^2))/((1+M*cos(theta(j)))*(1+(M-M_c)*cos(theta(j)))^2); %Directivity function
    D_l = ((sin(theta(j)))^2*(sin(phi))^2)/((1+M*cos(theta(j)))^4);

    %determining K_1 from Reynolds number
    if R_c < 2.47*10^5;
        K_1 = -4.31*log10(R_c)+156.3;
    else if R_c > 8.0*10^5;
            K_1 = 128.5;
        else 
            K_1 = -9.0*log10(R_c)+181.6;
        end
    end

    %determining deltaK_1 from R_deltap
    if R_deltaS_p <= 5000;
        deltaK_1 = alpha(j)*(1.43*log10(R_deltaS_p)-5.29);
    else
        deltaK_1 = 0;
    end

    %gamma and beta based on Mach number
    gamma = 27.094*M+3.31;
    gamma_0 = 23.43*M+4.651;
    beta = 72.65*M+10.74;
    beta_0 = -34.19*M-13.82;

    %determining K_2 based on alpha
    if alpha(j) < gamma_0-gamma;
        K_2 = K_1-1000;
    else if alpha(j) > gamma_0+gamma;
            K_2 = K_1-12;
        else
            K_2 = K_1 + sqrt((beta^2)-((beta/gamma)^2)*((alpha(j)-gamma_0)^2))+beta_0;
        end
    end
    SPL_p(j,:) = 10*log10((deltaS_p.*(M^5)*L*D_h)/(r_e^2))+Ap+(K_1-3)+deltaK_1; %pressure side
    SPL_s(j,:) = 10*log10((deltaS_s.*(M^5)*L*D_h)/(r_e^2))+As+(K_1-3); %suction side
    if alpha(j) > gamma_0 || alpha(j) > 12.5
        R_c = 3*R_c;
        if R_c < 9.52*10^4;
            a_0 = .57;
        else if R_c > 8.57*10^5;
                a_0 = 1.13;
            else
                a_0 = (-9.57*10^-13)*((R_c-(8.57*10^5))^2)+1.13;
            end
        end
        if R_c < 2.47*10^5;
            K_1 = -4.31*log10(R_c)+156.3;
        else if R_c > 8.0*10^5;
                K_1 = 128.5;
            else
                K_1 = -9.0*log10(R_c)+181.6;
            end
        end
        if alpha(j) < gamma_0-gamma;
            K_2 = K_1-1000;
        else if alpha(j) > gamma_0+gamma;
                K_2 = K_1-12;
            else
                K_2 = K_1 + sqrt((beta^2)-((beta/gamma)^2)*((alpha(j)-gamma_0)^2))+beta_0;
            end
        end
        A_R = (-20-A_min(a_0))/(A_max(a_0)-A_min(a_0));
        Anew = A_min(anew)+A_R*(A_max(anew)-A_min(anew));
        SPL_a(j,:) = 10*log10((deltaS_s.*(M^5)*L*D_l)/(r_e^2))+Anew+K_2;
    else
        SPL_a(j,:) = 10*log10((deltaS_s.*(M^5)*L*D_h)/(r_e^2))+B+K_2; %seperation noise
    end
    SPL_tot(j,:) = 10*log10(10.^(SPL_a(j,:)/10)+10.^(SPL_p(j,:)/10)+10.^(SPL_s(j,:)/10)); %Sound Pressure Level
end
Es=0;
Ep=0;
Ea=0;
ET=0;
for k=1:1:j
    Es=Es+(10.^(SPL_s(k,:)/10));
    Ep=Ep+(10.^(SPL_p(k,:)/10));
    Ea=Ea+(10.^(SPL_a(k,:)/10));
    ET=ET+(10.^(SPL_tot(k,:)/10));
end
SPL_S=10*log10(Es);
SPL_P=10*log10(Ep);
SPL_A=10*log10(Ea);
SPL_TOT=10*log10(ET);

if showplot
    figure();
    semilogx(f,SPL_TOT,'k-');
    xlim([100 10000]);
    xlabel('Frequency, Hz');
    ylabel('SPL, dB');
end
end

function[A_min]=A_min(a)
A_min=zeros(1,length(a));
for i=1:1:length(a)
    if a(i) < 0.204;
        A_min(i) = sqrt(67.552-886.788*a(i)^2)-8.219;
    else if a(i) > 0.244;
            A_min(i) = -142.795*a(i)^3+103.656*a(i)^2-57.757*a(i)+6.006;
        else
            A_min(i) = -32.665*a(i)+3.981;
        end
    end
end
end

function[A_max]=A_max(a)
A_max=zeros(1,length(a));
for i=1:1:length(a)
    if a(i) < 0.13;
        A_max(i) = sqrt(67.552-886.788*a(i)^2)-8.219;
    else if a(i) > 0.321;
            A_max(i) = -4.669*a(i)^3+3.491*a(i)^2-16.699*a(i)+1.149;
        else
            A_max(i) = -15.901*a(i)+1.098;
        end
    end
end
end

function[B_min]=B_min(b)
B_min=zeros(1,length(b));
for i=1:1:length(b)
    if b(i) < 0.13;
        B_min(i) = sqrt(16.888-886.788*b(i)^2)-4.109;
    else if b(i) > 0.145;
            B_min(i) = -817.810*b(i)^3+355.210*b(i)^2-135.024*b(i)+10.619;
        else
            B_min(i) = -83.607*b(i)+8.138;
        end
    end
end
end

function[B_max]=B_max(b)
B_max=zeros(1,length(b));
for i=1:1:length(b)
    if b(i) < 0.1;
        B_max(i) = sqrt(16.888-886.788*b(i)^2)-4.109;
    else if b(i) > 0.187;
            B_max(i) = -80.541*b(i)^3+44.174*b(i)^2-39.381*b(i)+2.344;
        else
            B_max(i) = -31.33*b(i)+1.854;
        end
    end
end
end