% Brooks, Pope and Marcolini exaomple application, (c) William Devenport, October 2016
clear all

parm.r_e = 3; % Retarded source to observer distance, in m, scalar.
parm.theta= 90; % Retarded source to observer angle in degrees measured from downstream, scalar
parm.phi = 90; %Lateral directivity angle term in degrees, scalar
parm.c = 0.23; %Chordlength(m). Scalar or 1xN vector 
parm.L = 1.22; %Span (m). Scalar or 1xN vector
parm.alpha=0; %Angle of attack in degrees. Scalar or 1xN vector
parm.U=55.5; %Free stream velocity. Scalar or 1xN vector 
parm.v = 0.0000181206/1.22500; %Kinetmatic Viscosity of air in m^2/s
parm.c0 = 340; %Speed of sound in m/s
parm.trip=1; %Trip condition, 0 - untripped, 1 - tripped (BPM fit), 2 - prescribed delta*
parm.deltaS_s=0.006943*parm.c;
parm.deltaS_p=0.006943*parm.c;
parm.plot=0;

figure
syms={'ko','k^','ks','kd','kh','kv'};
alpha=[0 2 4 5.3 7.3];
for n=1:length(alpha)
    parm.alpha=alpha(n); %Angle of attack in degrees. Scalar or 1xN vector
    [f,SPL_TOT,SPL_S,SPL_P,SPL_A,deltaS_p,deltaS_s]=BPM_TBL_TE_Noise(parm);
    m=floor(3*log(length(f))/log(2));
    pt=round(2.^((0:m)/3));p=pt(find(pt<=length(f)));
    h=semilogx(f(p),SPL_TOT(p),syms{n});hold on;
    set(h,'Markersize',5);
    leg{n}=['\alpha = ' num2str(alpha(n))];
end

legend(leg);
xlim([100 10000]);
ylim([30 70]);
set(gca,'Fontsize',12');
set(gcf,'Position',[411   675   560   272]);


