clear


M=40;
ro=0.05;
rmax=1.18/2;
tmax=5*(2*pi);
Lam=343/3000;

h=(1/tmax)*log(rmax/ro);

Lmax=ro*sqrt(1+h^2)*(exp(h*tmax)-1)/h;


m=1:M;

lm=(m-1)*Lmax/(M-1);
tm=log(1+h*lm/(ro*sqrt(1+h^2)))/h;

rm=ro*exp(h*tm);

dt=0.01;
t=0:dt:tmax;
r=ro*exp(h*t);

figure(1)

xm=rm.*cos(tm);ym=rm.*sin(tm);
x=r.*cos(t);y=r.*sin(t);

plot(xm,ym,'ok',x,y,'k')
axis equal
%axis off

t1=2*pi/3;
xm2=[rm.*cos(tm),rm.*cos(tm+t1),rm.*cos(tm+2*t1)];%,rm.*cos(tm+3*t1),rm.*cos(tm+4*t1)];
ym2=[rm.*sin(tm),rm.*sin(tm+t1),rm.*sin(tm+2*t1)];%,rm.*sin(tm+3*t1),rm.*sin(tm+4*t1)];

figure(2)
plot(xm2,ym2,'ok')
axis equal

ro=5;

x1=xm;x3=ym;

y=-3:0.1:3;
[Y1,Y3]=meshgrid(y,y);
N=length(y);
y1=reshape(Y1,1,N^2);
y3=reshape(Y3,1,N^2);

[X1,Y1]=meshgrid(x1,y1);
[X3,Y3]=meshgrid(x3,y3);

r=sqrt((X1-Y1).^2+(X3-Y3).^2+ro^2)';
k=2*pi/Lam;
G=exp(i*k*r)./(4*pi*r);

%W=exp(i*k*(X1.*Y1+X3.*Y3)'/ro);
W=G./norm(G);

F=abs((W'*G)).^2;

Fs=reshape(F(fix(N^2/2),:),N,N);

P=10*log10(Fs./max(max(Fs)));
P=(P>-12).*P+(P<=-12)*(-12);
figure(3)
mesh(y/Lam,y/Lam,P)
axis([-30,30,-30,30,-12,0])
xlabel('y_1/\lambda')
zlabel('point spread function dB')
ylabel('y_3/\lambda')











