clear

%Array design
M=40;
ro=0.05;
rmax=1.18/2;
tmax=5*(2*pi);
Lam=343/10000;

h=(1/tmax)*log(rmax/ro);

Lmax=ro*sqrt(1+h^2)*(exp(h*tmax)-1)/h;


m=1:M;

lm=(m-1)*Lmax/(M-1);
tm=log(1+h*lm/(ro*sqrt(1+h^2)))/h;

rm=ro*exp(h*tm);

dt=0.01;
t=0:dt:tmax;
r=ro*exp(h*t);

figure(1)

xm=rm.*cos(tm);ym=rm.*sin(tm);
x=r.*cos(t);y=r.*sin(t);

plot(xm,ym,'ok',x,y,'k')
axis equal
%axis off

%propagation Matrix

ro=5;

x1=xm;x3=ym;
ymax=3;ymin=-ymax;
dy1=3*(ymax-ymin)/M
dy2=(4*Lam*0.4)
dy=max([dy1,dy2])


y=ymin:dy:ymax;
[Y1a,Y3a]=meshgrid(y,y);
N=length(y);
y1=reshape(Y1a,1,N^2);
y3=reshape(Y3a,1,N^2);

[X1,Y1]=meshgrid(x1,y1);
[X3,Y3]=meshgrid(x3,y3);

r=sqrt((X1-Y1).^2+(X3-Y3).^2+ro^2)';
k=2*pi/Lam;
G=exp(i*k*r)./(4*pi*r);

%array processing

W=G./norm(G);
F=abs((W'*G)).^2;
n1=find(abs(Y1(:,1).^2+Y3(:,1).^2)<dy^2);
Fs=reshape(F(n1(1),:),N,N);

%point spread function
P=10*log10(Fs./max(max(Fs)));
P=(P>-12).*P+(P<=-12)*(-12);


nn=find(P>-3);
beam=2*mean(sqrt(Y1a(nn).^2+Y3a(nn).^2))
brooks=dy/beam


figure(3)
subplot(221)
mesh(y,y,P)
axis([-3,3,-3,3,-12,0])
xlabel('y_1')
zlabel('point spread function dB')
ylabel('y_3')
title('(a) point spread functiom')

%CSD matrix for LE/TE noise located y3=+/- 0.75m , y1=-0.75,0,
%q1=0.2,q2=1

q(N,N)=0;
n1=fix(N/2);n2=fix(N/4);
q(n1,[n2:(n1+n2)])=1;%y3([15:45]).^2;
q(n2,[n2:(n1+n2)])=0.2;%*y3([15:45]).^4;;

q=reshape(q,1,N^2);

Q=diag(q);
C=G*Q*G';

b=abs(diag(W'*C*W));
bmax=max(b);
bf=reshape(b/bmax,N,N);

figure(3)
subplot(223)
%pcolor(y,y,bf')
%axis equal
%shading interp
%colorbar
%contour(y,y,bf')
%xlabel('y_1')
%ylabel('y_3')
%title('(c) source image contour map')


figure(3)
subplot(222)
mesh(y,y,bf')
axis([-3,3,-3,3,0,1])
xlabel('y_1')
zlabel('Source Image Level \itb_k')
ylabel('y_3')
title('(b) Linear Source Image')
%DAMAS



qd=lsqnonneg(F,b);

qdmax=max(abs(qd));
qq=reshape(abs(qd)/qdmax,N,N);

figure(6)

pcolor(y,y,qq')
%shading interp
colorbar
xlabel('y1')
ylabel('y3')

figure(3)
subplot(223)
mesh(y,y,qq')
xlabel('y_1')
zlabel('Linear Source Level')
ylabel('y_3')
title('(c) DAMAS Source Image')

return


%CLEAN
be=b;Ce=C;
for nn=1:20;
[dd,kk]=max(be)
bc(nn)=dd;y1c(nn)=y1(kk);y3c(nn)=y3(kk);

Cc=G(:,kk)*dd*G(:,kk)';
Ce=Ce-Cc/norm(G)^2;

be=abs(diag(W'*Ce*W));

end

bmax=max(bc);

figure(8)

plot3(y1c,y3c,bc/bmax,'o')
%axis([-3,3,-3,3,0,1])

xlabel('y1')
ylabel('y3')





















