clear

dta=0.001;
tau=0:dta:1;

x1=40;x2=30;
th=2*pi*tau;

M=0.8;D=0;
t=[];Q=[];
f1=1;m=10;

R=0.9;

y1=0;y2=R*cos(th);
r=sqrt((x1-y1).^2+(x2-y2).^2);
ro=sqrt((x1).^2+(x2).^2);

t1=tau+(r-ro)*M/2/pi;

t=[t;t1];

Tv=0.02;
tt=(tau-0.5)/Tv;

L=tt.*exp(-tt.^2);
dL=exp(-tt.^2).*(1-2*tt.^2)/Tv;


Mr=-M*R*(x2*sin(th)/ro);
dMr=-M*R*(x2*cos(th)/ro);

if j==4;D=0;end
Q=-((x1/ro)./(1-Mr).^2).*(dL+L.*dMr./(1-Mr));


figure(1)
plot(tau-0.5,L,'-k')
xlabel('(\tau-\tau_o)/T_v')
ylabel('f(t)')

figure(2)
plot(t(1,:),Q(1,:),'-k')
%axis([0 1 -1 1]);
xlabel('(t-t_r_e_f)/T_p')
ylabel('C_p(t)')
%legend('R=0.3 R_t_i_p D/L=0.1','R=0.6 R_t_i_p D/L=0.1','R=0.9 R_t_i_p D/L=0.1','R=0.9 R_t_i_p D/L=0','Location','NorthWest')

N=64;
n=0:N-1;

m=-32:32;

[nn,mm]=meshgrid(n,m);

k=nn-mm;

Jm=[];
for m1=m
    a=n*M*R*x2/ro;
    Jm=[Jm;besselj(m1,a)];
end
Qmn=(i*nn*2*pi).*Jm.*(x1/ro).*(i*k*(pi*Tv)^2/sqrt(pi)).*exp(-i*mm*pi/2+i*k*pi-(k*pi*Tv).^2);

figure(3)
contour(n,m,abs(Qmn));
colorbar


xlabel('n')
ylabel('m')

cn=sum(Qmn);
figure(4)
plot(n,20*log10(abs(cn)),'.k')

axis([0,64,-60,10]);
xlabel('harmonic number')
ylabel('harmonic amplitude dB')

%[nj,nk]=meshgrid(n,n);
%ct=exp(-2*pi*i*nj.*nk/N)*cn.';

ct=fft(cn);%.*exp(i*n*M*ro));
ct=2*ct-cn(1);

figure(5)
plot(n/N,ct,'.k',t,Q,'k')

