clear

dta=0.001;
tau=0:dta:1;

x1=40;x2=30;
th=2*pi*tau;

M=0.8;D=0;
t=[];Q=[];
f1=1;m=10;

R=0.9;

y1=0;y2=R*cos(th);
r=sqrt((x1-y1).^2+(x2-y2).^2);
ro=sqrt((x1).^2+(x2).^2);

t1=tau+(r-ro)*M/2/pi;

t=[t;t1];


Mr=-M*R*(x2*sin(th)/ro);
dMr=-M*R*(x2*cos(th)/ro);
ddMr=-Mr;


Q=(1/(M*R)).*(ddMr./(1-Mr).^4+(3*dMr.^2)./(1-Mr).^5);

%Q=(1/(2*pi*M*R))*gradient(dMr./(1-Mr).^3,tau);


figure(1)
plot(t(1,:),Q(1,:),'-k')
axis([-0.2 1.2 -6 2]);
xlabel('(t-t_r_e_f)/T_p')
ylabel('C_q(t)')
%legend('R=0.3 R_t_i_p D/L=0.1','R=0.6 R_t_i_p D/L=0.1','R=0.9 R_t_i_p D/L=0.1','R=0.9 R_t_i_p D/L=0','Location','NorthWest')

N=128;
n=0:N-1;



[nn,mm]=meshgrid(n,m);


Jm=[];
for m1=n
    a=m1*M*R*x2/ro;
    Jm=[Jm,besselj(m1,a)];
end
cn=(i*n).^2.*Jm.*exp(-i*n*pi/2)/(M*R);


figure(4)
plot(n,20*log10(abs(cn)),'.k')

axis([0,64,-60,10]);
xlabel('harmonic number')
ylabel('harmonic amplitude dB')

%[nj,nk]=meshgrid(n,n);
%ct=exp(-2*pi*i*nj.*nk/N)*cn.';

ct=fft(cn);%.*exp(i*n*M*ro));
ct=2*ct-cn(1);

figure(5)
plot(n/N,ct,'.k',t,Q,'k')




