%Fig_6_19_Steady Loading Calculation

clear
Mt=0.5;
B=3;
Tv=0.1;
Po=50;


th=0.05:0.005:2*pi-0.05;
m=B;
Pe1=[];

for Nv=3:5;
a=B*Mt*sin(th);

cn=0;
for k=-10:10;
    m=B-k*Nv;
Jm=besselj(m,a);


cn=cn+cos(th).*Jm*(k*Nv^2)*exp(-(k*Nv*2*pi*Tv/2).^2);
end


P=20*log10(abs(cn));


Pe1=[Pe1;P];

end
Pe=Pe1-max(Pe1(:));
n=find(Pe(:)<-Po);
Pe(n)=NaN;
Pe=Pe+Po;

figure(1)
polarplot(th+pi,Pe(1,:),'k',th+pi,Pe(2,:),'-.k',th+pi,Pe(3,:),'--k')

%grid on
%axes([0, 2*pi, -20,1])